select
    l.id             ,
    l.cid            ,
    l.username       ,
    l.fullname       ,
    l.title          ,
    l.remote_ip      remoteIp,
    l.user_agent     userAgent,
    l.request_uri    requestUri,
    l.request_method requestMethod,
    l.is_valid       isValid,
    l.type           ,
    l.params         ,
    l.create_by      createBy,
    l.create_date    createDate,
    l.update_by      updateBy,
    l.update_date    updateDate,
    l.log_source     logSource,
    a.province_id provinceId,
    a.city_id cityId,
    a.area_id areaId,
    a.street_id streetId,
    la.name companyName
from sys_log l
         LEFT JOIN (
    select t.cid, t.area_id, t.name from (
                                             SELECT
                                                 id cid, name,
                                                 area_id
                                             FROM
                                                 organization o UNION all
                                             SELECT
                                                 id cid, name ,
                                                 area_id
                                             FROM
                                                 test3_bigdata.company UNION all
                                             SELECT
                                                 id cid,name,
                                                 case when area_id is not null then area_id
                                                      when city_id is not null then city_id
                                                      when province_id is not null then province_id end  area_id
                                             FROM
                                                 third_organization.third_organization
                                         ) t group by t.cid
) la ON l.cid = la.cid
         left join test3_bigdata.sys_area a on la.area_id = a.id
where
    la.cid  is not null  and l.id > :sql_last_value
order by l.id asc
